package ru.yandex.wmconsole.authorization;

import org.jetbrains.annotations.Nullable;

import ru.yandex.wmtools.common.data.info.OAuthScope;

/**
 * @author aherman
 */
public enum ApiOAuthPermission {
    VALIDATE_TOKEN_ONLY(),
    COMMON_OPERATIONS(      "verify"),
    PRIVILEGED_OPERATIONS(  "hostinfo"),
    ;

    private static final String OAUTH_SCOPE_PREFIX = "webmaster";

    private final OAuthScope oAuthScope;

    private ApiOAuthPermission() {
        this.oAuthScope = null;
    }

    private ApiOAuthPermission(String scopeName) {
        this.oAuthScope = new OAuthScope(OAUTH_SCOPE_PREFIX, scopeName);
    }

    @Nullable
    public OAuthScope getOAuthScope() {
        return oAuthScope;
    }
}
