package ru.yandex.wmconsole.servantlet;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.TcyInfo;
import ru.yandex.wmconsole.data.wrappers.BriefHostInfoWrapper;
import ru.yandex.wmconsole.data.wrappers.TcyInfoWrapper;
import ru.yandex.wmconsole.service.LinksCacheService;
import ru.yandex.wmtools.common.SupportedProtocols;
import ru.yandex.wmtools.common.data.wrappers.SimpleWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * Checks if specified host is verified by user.
 *
 * @author ailyin
 */
public class CheckHostVerificationServantlet extends WMCAuthenticationServantlet {
    private static final Logger log = LoggerFactory.getLogger(CheckHostVerificationServantlet.class);

    private static final int TCY_LIMIT = 10;

    private LinksCacheService linksCacheService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws InternalException, UserException {
        log.debug("CheckHostVerification: Started");

        BriefHostInfo briefInfo = getHostInfo(req, true);
        @SuppressWarnings({"SimplifiableConditionalExpression"})
        boolean verified = (briefInfo == null) ? false : getVerifyService().isHostVerifiedByUser(briefInfo.getId(), userId);
        res.addData(new SimpleWrapper<Boolean>(verified, "verified"));

        if (verified) {
            res.addData(new BriefHostInfoWrapper(briefInfo));

            URL hostname;
            try {
                hostname = SupportedProtocols.getURL(briefInfo.getName());
            } catch (MalformedURLException e) {
                throw new AssertionError("invalid hostname in a database!");
            } catch (URISyntaxException e) {
                throw new AssertionError("invalid hostname in a database!");
            } catch (SupportedProtocols.UnsupportedProtocolException e) {
                throw new AssertionError("there is a host in a database with unsupported protocol!");
            }
            Integer tcyValue = linksCacheService.checkCacheAndGetTcy(hostname);
            int tcy = (tcyValue == null) ? 0 : tcyValue;
            res.addData(new TcyInfoWrapper(new TcyInfo(TCY_LIMIT, tcy), "tcy-info"));
        }

        log.debug("CheckHostVerification: Finished");
    }

    @Required
    public void setLinksCacheService(LinksCacheService linksCacheService) {
        this.linksCacheService = linksCacheService;
    }
}
