package ru.yandex.wmconsole.servantlet;

import java.net.URL;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.framework.xml.wrapper.BooleanWrapper;
import ru.yandex.webmaster.viewer.service.SpammerDomainsCacheService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * Проверяет необходимость показа каптчи при добавлении хоста
 *
 * User: azakharov
 * Date: 13.10.12
 * Time: 13:27
 */
public class CheckShowCaptchaServantlet extends WMCAuthenticationServantlet {
    private static final String PARAM_HOST_NAME = "hostname";

    private SpammerDomainsCacheService spammerDomainsCacheService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        final String hostName = getRequiredStringParam(req, PARAM_HOST_NAME);
        URL url = prepareUrl(hostName, true);
        boolean needCaptcha = spammerDomainsCacheService.needCaptcha(url, userId);
        res.addData(
                new BooleanWrapper("show-captcha", needCaptcha)
        );
    }

    @Required
    public void setSpammerDomainsCacheService(SpammerDomainsCacheService spammerDomainsCacheService) {
        this.spammerDomainsCacheService = spammerDomainsCacheService;
    }
}
