package ru.yandex.wmconsole.servantlet;

import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.CommonInfo;
import ru.yandex.wmconsole.data.info.NotificationMessageInfo;
import ru.yandex.wmconsole.data.wrappers.CommonInfoWrapper;
import ru.yandex.wmconsole.service.MessageService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

public class CommonInfoServantlet extends WMCAuthenticationServantlet {
    private static final Logger log = LoggerFactory.getLogger(CommonInfoServantlet.class);

    protected MessageService messageService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws InternalException {

        BriefHostInfo hostInfo = null;
        try {
            hostInfo = getHostInfo(req);
        } catch (UserException e) {
            log.debug("CommonInfoServantlet: host param missed.  may be it's OK");
        } catch (InternalException e) {
            log.debug("CommonInfoServantlet: host param missed.  may be it's OK");
        }

        CommonInfo commonInfo = new CommonInfo(new Date());
        commonInfo.setShortHostInfos(getHostInfoService().getShortHostList(userId));
        commonInfo.setReadMessagesCount(messageService.getUserReadMessagesCount(userId));
        commonInfo.setUnreadMessagesCount(messageService.getUserUnreadMessagesCount(userId));
        List<NotificationMessageInfo> lastMessages = messageService.getLastMessages(userId, 1);
        commonInfo.setLastMessage(((lastMessages == null) || lastMessages.isEmpty()) ? null : lastMessages.get(0));

        res.addData(new CommonInfoWrapper(commonInfo, hostInfo));
    }

    @Required
    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }
}
