package ru.yandex.wmconsole.servantlet;

import java.net.URL;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.DelUrlRequest;
import ru.yandex.wmconsole.service.DelUrlService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AbstractServantlet;

/**
 * Encodes url using punycode and performs some checks.
 *
 * @author ailyin
 */
public class DelUrlServantlet extends AbstractServantlet {
    private static final Logger log = LoggerFactory.getLogger(DelUrlServantlet.class);

    private static final String PARAM_URL = "url";

    private DelUrlService delUrlService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res) throws UserException, InternalException {
        log.debug("DelUrl: Started");

        String urlString = getRequiredStringParam(req, PARAM_URL);
        URL url = prepareUrl(urlString, true);

        delUrlService.delUrl(new DelUrlRequest(url, req.getRemoteIp(), req.getUserId()));

        log.debug("DelUrl: Finished");
    }

    @Required
    public void setDelUrlService(DelUrlService delUrlService) {
        this.delUrlService = delUrlService;
    }
}
