package ru.yandex.wmconsole.servantlet;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.wrappers.StringWrapper;
import ru.yandex.wmconsole.util.BackportedIdUtils;
import ru.yandex.wmconsole.util.BackportedWebmasterHostId;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * @author avhaliullin
 */
public class GetNewWebmasterHostIdServantlet extends WMCAuthenticationServantlet {
    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        BriefHostInfo briefHostInfo = getHostInfoAndCheckHostAdded(req, userId);
        BackportedWebmasterHostId hostId = BackportedIdUtils.urlToHostId(briefHostInfo.getName());
        res.addData(new StringWrapper(hostId.toStringId(), "host-id"));
        String prettyHostId = hostId.getSchema().getSchemaName() + ":" + hostId.getReadableHostname() + ":" + hostId.getPort();
        res.addData(new StringWrapper(prettyHostId, "readable-host-id"));
    }
}
