package ru.yandex.wmconsole.servantlet;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.service.LinksCacheService;
import ru.yandex.wmconsole.util.HostElementWrapper;
import ru.yandex.wmtools.common.SupportedProtocols;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author senin
 */
public class HostTcyServantlet extends WMCAuthorizedHostOperationServantlet {
    private LinksCacheService linksCacheService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {

        BriefHostInfo hostInfo = getHostInfoAndVerify(req, userId);
        URL hostname;
        try {
            hostname = SupportedProtocols.getURL(hostInfo.getName());
        } catch (MalformedURLException e) {
            throw new AssertionError("invalid hostname in a database!");
        } catch (URISyntaxException e) {
            throw new AssertionError("invalid hostname in a database!");
        } catch (SupportedProtocols.UnsupportedProtocolException e) {
            throw new AssertionError("there is a host in a database with unsupported protocol!");
        }

        Integer tcyValue = linksCacheService.checkCacheAndGetTcy(hostname);
        final int tcy = (tcyValue == null) ? 0 : tcyValue;
        res.addData(new HostElementWrapper(new XmlDataWrapper<Integer>(tcy) {
            @Override
            protected void doToXml(StringBuilder result) {
                putIntegerTag(result, "tcy-value", data);
            }
        }, hostInfo));
    }

    @Required
    public void setLinksCacheService(LinksCacheService linksCacheService) {
        this.linksCacheService = linksCacheService;
    }
}
