package ru.yandex.wmconsole.servantlet;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.service.LogErrorService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * Сервантлет для логгирования js-ошибок
 *
 * User: azakharov
 * Date: 29.12.12
 * Time: 17:49
 */
public class LogErrorServantlet extends WMCAuthenticationServantlet {
    private static final String PARAM_BROWSER = "browser";
    private static final String PARAM_MESSAGE = "message";
    
    private LogErrorService logErrorService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        final String browser = getRequiredStringParam(req, PARAM_BROWSER);
        final String message = getRequiredStringParam(req, PARAM_MESSAGE);
        logErrorService.logError(userId, browser, message);
    }

    @Required
    public void setLogErrorService(LogErrorService logErrorService) {
        this.logErrorService = logErrorService;
    }
}
