package ru.yandex.wmconsole.servantlet;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.util.db.OrderByClause;
import ru.yandex.webmaster.common.urltree.YandexSearchShard;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.TreeInfo;
import ru.yandex.wmconsole.data.wrappers.TreeInfoWrapper;
import ru.yandex.wmconsole.service.LinksCacheService;
import ru.yandex.wmconsole.service.UrlTreeService;
import ru.yandex.wmconsole.util.HostElementWrapper;
import ru.yandex.wmconsole.util.TreeOrderByClause;
import ru.yandex.wmtools.common.data.strategy.OutputStrategy;
import ru.yandex.wmtools.common.data.strategy.OutputStrategyTypeEnum;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

public class UrlTreeServantlet extends WMCAuthorizedHostOperationServantlet {
    private static final String PARAM_URL_NODE_ID = "id";

    private UrlTreeService urlTreeService;
    private LinksCacheService linksCacheService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {

        BriefHostInfo briefHostInfo = getHostInfo(req, false, userId, true, true, res, true, true);
        if (briefHostInfo == null) {
            return;
        }
        // Проверяем, что сайт проиндексирован обычным роботом или быстророботом
        checkIndexed(briefHostInfo);

        Long urlGroupId = getLongParam(req, PARAM_URL_NODE_ID);

        OrderByClause treeOrder = new TreeOrderByClause(req);

        final Long totalNumOfUrls = urlTreeService.getHostUrlCount(briefHostInfo);
        final Long indexCount;
        if (totalNumOfUrls == null || totalNumOfUrls == 0) {
            indexCount = linksCacheService.checkCacheAndGetIndexCount(briefHostInfo, YandexSearchShard.RU);
        } else {
            indexCount = null;
        }
        TreeInfo treeInfo = urlTreeService.getUrlTreeInfo(briefHostInfo, urlGroupId);

        OutputStrategy outputStrategy = createOutputStrategy(req);

        if (treeInfo == null) {
            long urlCount = getUrlCount(totalNumOfUrls, indexCount);
            // здесь indexCount берется из xml-поиска, так как в таблице tbl_url_trees не нашлось записей
            treeInfo = urlTreeService.createFakeRootNode(briefHostInfo.getName(), urlCount, indexCount);
            TreeInfoWrapper urlTreeInfoWrapper = new TreeInfoWrapper(treeInfo, treeOrder, !(outputStrategy.getType() == OutputStrategyTypeEnum.VIEW));
            res.addData(new HostElementWrapper(urlTreeInfoWrapper, briefHostInfo));
            return;
        }
        TreeInfoWrapper urlTreeInfoWrapper = new TreeInfoWrapper(treeInfo, treeOrder, !(outputStrategy.getType() == OutputStrategyTypeEnum.VIEW));
        res.addData(new HostElementWrapper(urlTreeInfoWrapper, briefHostInfo) {
            @Override
            protected void doToXml(StringBuilder result) {
                super.doToXml(result);
                long urlCount = getUrlCount(totalNumOfUrls, indexCount);

                putLongTag(result, "urls", urlCount);
            }
        });
    }

    public long getUrlCount(final Long urlCount, final Long idx) {
        final long indexCount = idx == null ? 0 : idx;
        long urls = urlCount == null ? 0 : urlCount;
        if (urls == 0 && indexCount > 0) {
            return indexCount;
        }
        return urls;
    }

    @Required
    public void setUrlTreeService(UrlTreeService urlTreeService) {
        this.urlTreeService = urlTreeService;
    }

    @Required
    public void setLinksCacheService(LinksCacheService linksCacheService) {
        this.linksCacheService = linksCacheService;
    }
}
