package ru.yandex.wmconsole.servantlet;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.util.collections.Pair;
import ru.yandex.wmconsole.data.wrappers.UserInfoExtendedWrapper;
import ru.yandex.wmtools.common.data.info.WMUserInfo;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

public class UserOptionsServantlet extends WMCAuthenticationServantlet {
    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        WMUserInfo userInfo = getUserInfoService().getUserInfo(userId);
        Pair<Boolean, Boolean> options = getUserInfoService().getUserOptions(userId);
        res.addData(new UserInfoExtendedWrapper(userInfo, options.first, options.second));
    }
}
