package ru.yandex.wmconsole.servantlet.all.about.url;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.util.db.OrderByClause;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.all.about.url.UrlRequestId;
import ru.yandex.wmconsole.servantlet.WMCAuthorizedHostOperationServantlet;
import ru.yandex.wmconsole.service.AllAboutUrlService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.URLUtil;

import java.net.URL;

/**
 * User: azakharov
 * Date: 15.10.13
 * Time: 19:23
 */
public abstract class AbstractAllAboutUrlServantlet extends WMCAuthorizedHostOperationServantlet {

    private static final String PARAM_REPORT_ID = "id";

    private AllAboutUrlService allAboutUrlService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        // хост добавлен и права подтверждены
        BriefHostInfo hostInfo = getHostInfoAndCheckHostVerified(req, userId);

        // обработка конкретного запроса из серии всё о странице
        processUrlRequest(req, res, userId, hostInfo);
    }

    private BriefHostInfo getHostInfoAndCheckHostVerified(ServRequest req, long userId) throws UserException, InternalException {
        final String paramHost = "host";
        String host = req.getParam(paramHost);
        if (host != null && host.contains("/")) {
            URL newHost = prepareHostname(host, true);
            req.setParam(paramHost, URLUtil.getHostName(newHost,false));
        }
        return getHostInfoAndVerify(req, userId);
    }

    protected OrderByClause getOrderByClause(final ServRequest req) {
        OrderByClause orderBy = new OrderByClause(
                req, allAboutUrlService.getDefaultOrderByDbField(), false,
                allAboutUrlService.getOrderByCorrespondence());
        return orderBy;
    }

    protected UrlRequestId getRequestId(final ServRequest req) throws UserException {
        return new UrlRequestId(getRequiredLongParam(req, PARAM_REPORT_ID));
    }

    protected boolean getFromSupport() {
        return false;
    }

    protected abstract void processUrlRequest(ServRequest req, ServResponse res, long userId, BriefHostInfo hostInfo)
            throws InternalException, UserException;

    @Required
    public void setAllAboutUrlService(AllAboutUrlService allAboutUrlService) {
        this.allAboutUrlService = allAboutUrlService;
    }

    public AllAboutUrlService getAllAboutUrlService() {
        return allAboutUrlService;
    }
}
