package ru.yandex.wmconsole.servantlet.all.about.url;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

import java.net.URL;

/**
 * Добавление запроса информации об url
 *
 * User: azakharov
 * Date: 08.02.13
 * Time: 19:34
 */
public class AddUrlRequestServantlet extends AbstractAllAboutUrlServantlet {
    
    private static final String PARAM_URL = "url";
    private static final Logger log = LoggerFactory.getLogger(AddUrlRequestServantlet.class);

    @Override
    protected void processUrlRequest(ServRequest req, ServResponse res, long userId, BriefHostInfo hostInfo) throws InternalException, UserException {
        String urlParam = getRequiredStringParam(req, PARAM_URL);
        // Проверяем, что URL относится к хосту
        URL url = getAllAboutUrlService().getUrlAndCheckUrlIsFromHost(hostInfo, urlParam, userId, getFromSupport());
        // Записываем запрос в базу
        getAllAboutUrlService().addUrlRequest(hostInfo, url, getFromSupport());
    }
}
