package ru.yandex.wmconsole.servantlet.all.about.url;

import java.util.List;

import javax.xml.bind.JAXBException;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.framework.pager.Pager;
import ru.yandex.common.util.db.OrderByClause;
import ru.yandex.webmaster.viewer.view.all.about.url.UrlListView;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.all.about.url.ShortUrlInfo;
import ru.yandex.wmconsole.util.XmlUtil;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.InternalProblem;
import ru.yandex.wmtools.common.error.UserException;

/**
 * История
 *
 * User: azakharov
 * Date: 08.02.13
 * Time: 20:14
 */
public class UrlInfoListServantlet extends AbstractAllAboutUrlServantlet {

    private static String PARAM_ID = "id";

    @Override
    protected void processUrlRequest(ServRequest req, ServResponse res, long userId, BriefHostInfo hostInfo) throws InternalException, UserException {
        // получаем опциональный список номеров отчётов, по которым требуется информация
        List<Long> ids = req.getMultiParamsAsLongList(PARAM_ID);

        // получаем список запрошенных страниц
        OrderByClause orderBy = getOrderByClause(req);
        List<ShortUrlInfo> urls = getAllAboutUrlService().getUrlInfoList(hostInfo, ids, orderBy, getFromSupport());

        // учитываем разбивку на страницы
        Pager pager = createOutputStrategy(req).createPager();
        pager.setCount(urls.size());
        urls = urls.subList(pager.getFrom() - 1, Math.min(pager.getTo(), urls.size()));

        // выводим результат
        try {
            // список
            res.addData(XmlUtil.xmlConvertable(new UrlListView(urls)));
            // пейджер
            res.addData(pager);
        } catch (JAXBException e) {
            throw new InternalException(InternalProblem.INTERNAL_PROBLEM, "jaxb processing error", e);
        }
    }
}
