package ru.yandex.wmconsole.servantlet.api;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.webmaster.common.host.dao.TblUsersHostsDao;
import ru.yandex.webmaster.viewer.service.NewWebmasterProxyService;
import ru.yandex.webmaster.viewer.service.webmaster3.HostVerificationInfo;
import ru.yandex.wmconsole.authorization.ApiOAuthPermission;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.wrappers.NoDataWrapper;
import ru.yandex.wmconsole.error.ClientException;
import ru.yandex.wmconsole.error.ClientProblem;
import ru.yandex.wmconsole.verification.VerificationMoment;
import ru.yandex.wmconsole.verification.VerificationTypeEnum;
import ru.yandex.wmtools.common.error.InternalException;

import java.sql.Date;

/**
 * @author ailyin
 */
public class ApiVerifyHostServantlet extends AbstractApiServantlet {
    private static final Logger log = LoggerFactory.getLogger(ApiVerifyHostServantlet.class);

    private NewWebmasterProxyService newWebmasterProxyService;
    private TblUsersHostsDao tblUsersHostsDao;

    @Override
    public void apiDoProcess(ServRequest req, ServResponse res, long userId) throws ClientException, InternalException {
        BriefHostInfo hostInfo = getHostInfoAndCheckHostAdded(req, userId);

        String paramTypeStr = getRequiredXmlParam(req, "/host/type");
        VerificationTypeEnum verificationType = VerificationTypeEnum.R.valueOfOrNull(paramTypeStr);

        log.debug("ver type=" + verificationType);
        if (verificationType == null || verificationType == VerificationTypeEnum.TXT_FILE
                || verificationType.getMoment() != VerificationMoment.ON_USER_DEMAND) {
            if (verificationType == VerificationTypeEnum.TXT_FILE) {
                log.error("Txt verification disabled");
            }
            throw new ClientException(ClientProblem.ILLEGAL_PARAM_VALUE, "Invalid param value: " + paramTypeStr);
        }
        long uin = tblUsersHostsDao.getUin(userId, hostInfo.getId());
        HostVerificationInfo hostVerificationInfo =
                newWebmasterProxyService.verifyHost(userId, hostInfo, uin, verificationType);
        Date date = hostVerificationInfo.getVerificationDate() == null ? null : new Date(hostVerificationInfo.getVerificationDate().getTime());
        tblUsersHostsDao.addUserHostFromNewWmc(
                userId,
                hostInfo.getId(),
                hostVerificationInfo.getState(),
                hostVerificationInfo.getVerificationType(),
                hostVerificationInfo.getVerificationUin(),
                date
        );
        res.addData(new NoDataWrapper("ok"));
    }

    @Override
    public ApiOAuthPermission getRequiredPermission() {
        return ApiOAuthPermission.COMMON_OPERATIONS;
    }

    @Required
    public void setNewWebmasterProxyService(NewWebmasterProxyService newWebmasterProxyService) {
        this.newWebmasterProxyService = newWebmasterProxyService;
    }

    @Required
    public void setTblUsersHostsDao(TblUsersHostsDao tblUsersHostsDao) {
        this.tblUsersHostsDao = tblUsersHostsDao;
    }
}
