package ru.yandex.wmconsole.servantlet.api.delegate;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.authorization.ApiOAuthPermission;
import ru.yandex.wmconsole.error.ClientException;
import ru.yandex.wmconsole.servantlet.api.AbstractApiServantlet;
import ru.yandex.wmtools.common.error.InternalException;

/**
 * @author avhaliullin
 */
public class DelegatingApiServantlet extends AbstractApiServantlet {
    private DelegateServantlet delegate;

    private ApiOAuthPermission permission;

    @Override
    protected void apiDoProcess(ServRequest req, ServResponse res, long userId) throws ClientException, InternalException {
        delegate.delegateWork(req, res, userId);
    }

    @Override
    public ApiOAuthPermission getRequiredPermission() {
        return permission;
    }

    @Required
    public void setPermission(ApiOAuthPermission permission) {
        this.permission = permission;
    }

    @Required
    public void setDelegate(DelegateServantlet delegate) {
        this.delegate = delegate;
    }
}
