package ru.yandex.wmconsole.servantlet.compare;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringEscapeUtils;
import org.jdom.Document;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.framework.pager.Pager;
import ru.yandex.common.util.collections.Pair;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.HostRegionService;
import ru.yandex.wmconsole.service.RegionsCompareService;
import ru.yandex.wmtools.common.data.info.RegionInfo;
import ru.yandex.wmtools.common.data.wrappers.JDOMWrapper;
import ru.yandex.wmtools.common.data.wrappers.RegionInfoWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.service.RegionsTreeCacheService;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

public class AllKeyRegionsCompareServantlet extends WMCAuthenticationServantlet {
    private class ResultForRegionFetcher extends Thread {
        private Pair<String, Document> result = null;
        private final Pager pager = new Pager(0, 20);
        private final String query;
        private final RegionInfo region;

        public ResultForRegionFetcher(String query, RegionInfo region) {
            this.query = query;
            this.region = region;
        }

        @Override
        public void run() {
            try {
                result = regionsCompareService.getResultForRegion(query, region.getId(), pager);
            } catch (UserException e) {
                result = null;
            } catch (InternalException e) {
                result = null;
            }
        }

        public Pair<String, Document> getResult() {
            return result;
        }

        public RegionInfo getRegion() {
            return region;
        }
    }

    private static final String PARAM_QUERY = "query";

    private RegionsCompareService regionsCompareService;
    private HostRegionService hostRegionService;
    private RegionsTreeCacheService regionsTreeCacheService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        checkService(regionsCompareService, RegionsCompareService.class);
        checkService(hostRegionService, HostRegionService.class);

        String query = getRequiredStringParam(req, PARAM_QUERY);

        List<RegionInfo> keyRegionsList = regionsTreeCacheService.getOldKeyRegionsForRegionsCompareInfo();

        Map<Integer, Pair<String, Document>> results = new HashMap<Integer, Pair<String, Document>>();
        List<ResultForRegionFetcher> rfrfs = new ArrayList<ResultForRegionFetcher>();
        for (RegionInfo region : keyRegionsList) {
            ResultForRegionFetcher rfrf = new ResultForRegionFetcher(query, region);
            rfrf.start();
            rfrfs.add(rfrf);
        }
        for (ResultForRegionFetcher rfrf : rfrfs) {
            try {
                rfrf.join();
            } catch (InterruptedException e) {
                throw new AssertionError("This should not be interrupted.");
            }

            Pair<String, Document> result = rfrf.getResult();
            if (result != null) {
                results.put(rfrf.getRegion().getId(), result);
            }
        }
        if (!results.isEmpty()) {
            res.addData(new XmlDataWrapper<String>(results.values().iterator().next().getFirst(), "query") {
                @Override
                protected void doToXml(StringBuilder result) {
                    result.append(StringEscapeUtils.escapeXml10(data));
                }
            });
            for (Map.Entry<Integer, Pair<String, Document>> entry : results.entrySet()) {
                res.addData(new JDOMWrapper(entry.getValue().getSecond(), "region", "id", Long.toString(entry.getKey())));
            }
        }
        res.addData(XmlConvertableCollectionWrapper.wrap(keyRegionsList, RegionInfoWrapper.class, "key-regions"));
    }

    @Required
    public void setRegionsCompareService(RegionsCompareService regionsCompareService) {
        this.regionsCompareService = regionsCompareService;
    }

    @Required
    public void setHostRegionService(HostRegionService hostRegionService) {
        this.hostRegionService = hostRegionService;
    }

    @Required
    public void setRegionsTreeCacheService(RegionsTreeCacheService regionsTreeCacheService) {
        this.regionsTreeCacheService = regionsTreeCacheService;
    }
}
