package ru.yandex.wmconsole.servantlet.compare;

import java.io.UnsupportedEncodingException;

import javax.mail.Header;
import javax.mail.MessagingException;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.InternalProblem;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AbstractServantlet;
import ru.yandex.wmtools.common.service.MailService;

/**
 * @author senin
 */
@Deprecated
public class  RegionsCompareFeedbackServantlet extends AbstractServantlet {
    private static final String PARAM_CONTENT = "content";
    private static final String PARAM_QUERY = "query";
    private static final String PARAM_REGION_1 = "region1";
    private static final String PARAM_REGION_2 = "region2";

    private MailService mailService;
    private String feedbackAddress;

    @Override
    protected void doProcess(ServRequest req, ServResponse res) throws InternalException, UserException {
        String query = getRequiredStringParam(req, PARAM_QUERY);
        String content = getRequiredStringParam(req, PARAM_CONTENT);
        Long region1 = getRequiredLongParam(req, PARAM_REGION_1);
        Long region2 = getRequiredLongParam(req, PARAM_REGION_2);
        content = "[" + query + "]\r\n[" + region1 + "," + region2 + "]\r\n" + content;

        try {
            mailService.sendWithAttachments(
                "Regions compare comment",
                content,
                new String[]{ feedbackAddress },
                null,
                "webmaster.yandex.ru",
                "hello@yandex-team.ru",
                null,
                new Header("X-RegionCompare-Region1", Long.toString(region1)),
                new Header("X-RegionCompare-Region2", Long.toString(region2)),
                new Header("X-RegionCompare-Query", query)
            );
        } catch (MessagingException e) {
            throw new InternalException(InternalProblem.MESSAGING_ERROR, "Messaging exception.", e);
        } catch (UnsupportedEncodingException e) {
            throw new InternalException(InternalProblem.MESSAGING_ERROR, "Unsupported encoding.", e);
        }
    }

    @Required
    public void setMailService(MailService mailService) {
        this.mailService = mailService;
    }

    @Required
    public void setFeedbackAddress(String feedbackAddress) {
        this.feedbackAddress = feedbackAddress;
    }
}
