package ru.yandex.wmconsole.servantlet.errors;

import java.util.Collection;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.util.db.OrderByClause;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.UrlErrorsWithCodeInfo;
import ru.yandex.wmconsole.data.wrappers.UrlErrorsWithCodeInfoWrapper;
import ru.yandex.wmconsole.servantlet.WMCAuthorizedHostOperationServantlet;
import ru.yandex.wmconsole.service.ErrorInfoService;
import ru.yandex.wmconsole.util.HostElementWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

/**
 * Выдает список групп ошибок и их количества.
 *
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 20.03.2007
 * Time: 16:58:13
 */
public class ErrorInfoGroupsServantlet extends WMCAuthorizedHostOperationServantlet {

    private ErrorInfoService errorInfoService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {

        BriefHostInfo briefHostInfo = getHostInfo(req, false, userId, true, true, res, true, true);
        if (briefHostInfo == null) {
            return;
        }
        // Проверяем, что сайт проиндексирован обычным роботом или быстророботом
        checkIndexed(briefHostInfo);

        OrderByClause order = new OrderByClause((String) null); // do not sort

        Collection<UrlErrorsWithCodeInfo> urlErrors = errorInfoService.getOrderedErrorGroupsList(userId, briefHostInfo, order);

        XmlConvertableCollectionWrapper wrappedUrlErrors = XmlConvertableCollectionWrapper.wrap(urlErrors, UrlErrorsWithCodeInfoWrapper.class, null);
        res.addData(new HostElementWrapper(wrappedUrlErrors, briefHostInfo));
    }

    @Required
    public void setErrorInfoService(ErrorInfoService errorInfoService) {
        this.errorInfoService = errorInfoService;
    }
}
