package ru.yandex.wmconsole.servantlet.errors;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.framework.xml.wrapper.BooleanWrapper;
import ru.yandex.wmconsole.data.UserErrorOptions;
import ru.yandex.wmconsole.data.info.UserOptionsInfo;
import ru.yandex.wmconsole.data.wrappers.InTagWrapper;
import ru.yandex.wmconsole.data.wrappers.UserErrorOptionsWrapper;
import ru.yandex.wmconsole.service.ErrorInfoService;
import ru.yandex.wmconsole.service.UserOptionsService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;

public class ErrorOptionsInfoServantlet extends AuthenticationServantlet {
    // Хост, для которого показываются настройки
    private static final String PARAM_HOST = "host";

    private static final String TAG_GLOBAL_OPTIONS = "global-options";
    private static final String TAG_DEFAULT = "default";

    private ErrorInfoService errorInfoService;

    private UserOptionsService userOptionsService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws InternalException, UserException {
        checkService(errorInfoService, ErrorInfoService.class);

        Long host = getLongParam(req, PARAM_HOST);
        UserOptionsInfo userOptions = userOptionsService.getUserOptions(userId);
        final UserErrorOptions userErrorOptions;
        UserErrorOptions defaultUserErrorOptions = new UserErrorOptions(userId);
        if (!userOptions.isUseGlobalErrorOptions() && host == null) {
            // если используются настройки для сайта и сайт не задан, то показываем настройки по-умолчанию
            userErrorOptions = defaultUserErrorOptions;
        } else {
            userErrorOptions = errorInfoService.getUserErrorOptions(userId, host, userOptions.isUseGlobalErrorOptions());
        }

        res.addData(new BooleanWrapper(TAG_GLOBAL_OPTIONS, userOptions.isUseGlobalErrorOptions()));

        res.addData(new UserErrorOptionsWrapper(userErrorOptions));

        res.addData(new InTagWrapper<UserErrorOptionsWrapper>(TAG_DEFAULT, new UserErrorOptionsWrapper(defaultUserErrorOptions)));
    }

    @Required
    public void setErrorInfoService(ErrorInfoService errorInfoService) {
        this.errorInfoService = errorInfoService;
    }

    @Required
    public void setUserOptionsService(UserOptionsService userOptionsService) {
        this.userOptionsService = userOptionsService;
    }
}
