package ru.yandex.wmconsole.servantlet.errors;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.util.db.OrderByClause;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.TreeInfo;
import ru.yandex.wmconsole.data.wrappers.TreeInfoWrapper;
import ru.yandex.wmconsole.servantlet.WMCAuthorizedHostOperationServantlet;
import ru.yandex.wmconsole.service.ErrorTreeService;
import ru.yandex.wmconsole.util.HostElementWrapper;
import ru.yandex.wmconsole.util.TreeOrderByClause;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * Выдает дерево разделов сайта, для страниц которых имеются ошибки
 *
 * User: azakharov
 * Date: 24.08.12
 * Time: 12:56
 */
public class ErrorTreeStructureServantlet extends WMCAuthorizedHostOperationServantlet {
    private static final String PARAM_ERROR_NODE_ID = "id";
    private static final String PARAM_ERROR_CODE = "code";

    private ErrorTreeService errorTreeService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {

        BriefHostInfo briefHostInfo = getHostInfo(req, false, userId, true, true, res, true, true);
        if (briefHostInfo == null) {
            return;
        }
        // Проверяем, что сайт проиндексирован обычным роботом или быстророботом
        checkIndexed(briefHostInfo);

        Integer errorCode = getRequiredIntParam(req, PARAM_ERROR_CODE);
        Long selectedNodeId = getLongParam(req, PARAM_ERROR_NODE_ID);

        OrderByClause treeOrder = new TreeOrderByClause(req);
        TreeInfo treeInfo = errorTreeService.getErrorTreeInfoByCode(userId, briefHostInfo, selectedNodeId, errorCode);
        if (treeInfo == null) {
            res.addData(new HostElementWrapper(null, briefHostInfo));
            return;
        }

        TreeInfoWrapper errorTreeInfoWrapper = new TreeInfoWrapper(treeInfo, treeOrder, false);

        res.addData(new HostElementWrapper(errorTreeInfoWrapper, briefHostInfo, "host-tree"));
    }

    @Required
    public void setErrorTreeService(ErrorTreeService errorTreeService) {
        this.errorTreeService = errorTreeService;
    }
}
