package ru.yandex.wmconsole.servantlet.errors;

import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.ErrorCountInfo;
import ru.yandex.wmconsole.data.info.ErrorUrlInfo;
import ru.yandex.wmconsole.data.wrappers.ErrorCountInfoWrapper;
import ru.yandex.wmconsole.data.wrappers.ErrorUrlInfoWrapper;
import ru.yandex.wmconsole.servantlet.WMCAuthorizedHostOperationServantlet;
import ru.yandex.wmconsole.service.ErrorInfoService;
import ru.yandex.wmconsole.util.HostElementWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

/**
 * Created by IntelliJ IDEA.
 * User: senin
 * Date: 20.03.2007
 * Time: 16:58:13
 */
public class ShowAllErrorsServantlet extends WMCAuthorizedHostOperationServantlet {
    private ErrorInfoService errorInfoService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {

        BriefHostInfo briefHostInfo = getHostInfo(req, true, userId, true, true);

        int[] primitive = errorInfoService.getPrimitiveCodesForUserAndHost(userId, briefHostInfo.getId());
        final List<ErrorUrlInfo> errorUrlInfos = errorInfoService.getAllErrors(userId, briefHostInfo, primitive);

        XmlConvertableCollectionWrapper wrappedUrlErrors =
                XmlConvertableCollectionWrapper.wrap(
                        errorUrlInfos,
                        ErrorUrlInfoWrapper.class,
                        "all-url-errors"
                );
        res.addData(new HostElementWrapper(wrappedUrlErrors, briefHostInfo));

        ErrorCountInfo errorCountInfo = errorInfoService.calcErrorCountInfo(briefHostInfo, primitive, null, false, false, null);
        res.addData(new ErrorCountInfoWrapper(errorCountInfo));
    }

    @Required
    public void setErrorInfoService(ErrorInfoService errorInfoService) {
        this.errorInfoService = errorInfoService;
    }
}
