package ru.yandex.wmconsole.servantlet.feedback;

import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmtools.common.data.info.EmailInfo;
import ru.yandex.wmtools.common.data.wrappers.ValidatorWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.service.ValidatorService;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class FeedbackInfoServantlet extends WMCAuthenticationServantlet {
    private ValidatorService validatorService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        List<EmailInfo> emails = validatorService.getEmails(userId);
        res.addData(XmlConvertableCollectionWrapper.wrap(emails, ValidatorWrapper.class, "emails"));
    }

    @Required
    public void setValidatorService(ValidatorService validatorService) {
        this.validatorService = validatorService;
    }
}
