package ru.yandex.wmconsole.servantlet.feedback;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmtools.common.error.InternalException;

public class SetFeedbackConfirmationOptionServantlet extends WMCAuthenticationServantlet {
    private static final String PARAM_NEED_FEEDBACK_CONFIRMATION = "need-feedback-confirmation";


    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws InternalException {

        Boolean needFeedbackConfirmationParam = getBooleanParam(req, PARAM_NEED_FEEDBACK_CONFIRMATION);
        boolean needFeedbackConfirmation = (needFeedbackConfirmationParam != null) && needFeedbackConfirmationParam;
        getUserInfoService().updateFeedbackConfirmationOption(userId, needFeedbackConfirmation);
    }
}
