package ru.yandex.wmconsole.servantlet.homepage;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.HomePageOptionsService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * Вызов сервантлета приводит к тому, что не показывается совет про настройки на промо-странице
 *
 * User: azakharov
 * Date: 05.04.12
 * Time: 19:38
 */
public class DisablePromotabTipsServantlet extends WMCAuthenticationServantlet {
    private static final Logger log = LoggerFactory.getLogger(HomePageOptionsChangeServantlet.class);

    private HomePageOptionsService homePageOptionsService;

    @Override
    protected void doProcess(final ServRequest req, final ServResponse res, final long userId) throws UserException, InternalException {
        assertUserExists(userId);
        homePageOptionsService.disableTip(userId);
        log.debug("Tip on promo page has been successfully disabled");
    }

    @Required
    public void setHomePageOptionsService(HomePageOptionsService homePageOptionsService) {
        this.homePageOptionsService = homePageOptionsService;
    }
}
