package ru.yandex.wmconsole.servantlet.homepage;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.HomePageOptionsService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * Сервис изменения настроек отображения главной страницы
 *
 * User: Alexey Zakharov <azakharov@yandex-team.ru>
 * Date: 31.01.12
 */
public class HomePageOptionsChangeServantlet extends WMCAuthenticationServantlet {
    private static final Logger log = LoggerFactory.getLogger(HomePageOptionsChangeServantlet.class);

    private HomePageOptionsService homePageOptionsService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        assertUserExists(userId);

        final Boolean redirectParam = getBooleanParam(req, "redirect-to-sites");
        final boolean redirectToMySites = redirectParam == null ? false : redirectParam;
        final Boolean showMetrikaErrorParam = getBooleanParam(req, "show-metrika-error");
        final boolean showMetrikaError = showMetrikaErrorParam == null ? false : showMetrikaErrorParam;
        homePageOptionsService.saveHomePageOptionsInfo(userId, redirectToMySites, showMetrikaError);
    }

    @Required
    public void setHomePageOptionsService(HomePageOptionsService homePageOptionsService) {
        this.homePageOptionsService = homePageOptionsService;
    }
}
