package ru.yandex.wmconsole.servantlet.homepage;

import javax.xml.bind.JAXBException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.util.xml.XmlConvertable;
import ru.yandex.wmconsole.data.info.HomePageOptionsInfo;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.HomePageOptionsService;
import ru.yandex.wmconsole.util.XmlUtil;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * Подготовка данных по текущим настройкам
 * User: Alexey Zakharov <azakharov@yandex-team.ru>
 * Date: 30.01.12
 */
public class HomePageOptionsInfoServantlet extends WMCAuthenticationServantlet {
    private static final Logger log = LoggerFactory.getLogger(HomePageOptionsInfoServantlet.class);

    private HomePageOptionsService homePageOptionsService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        assertUserExists(userId);
        HomePageOptionsInfo info = homePageOptionsService.getHomePageOptionsInfo(userId);
        XmlConvertable wrapper = null;
        try {
            wrapper = XmlUtil.xmlConvertable(info);
            res.addData(wrapper);
        } catch (JAXBException e) {
            log.debug("Exception in call XmlUtil.xmlConvertable " + e.getMessage());
        }
    }

    @Required
    public void setHomePageOptionsService(HomePageOptionsService homePageOptionsService) {
        this.homePageOptionsService = homePageOptionsService;
    }
}
