package ru.yandex.wmconsole.servantlet.hostlist;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.webmaster.common.host.dao.TblHostsHostDao;
import ru.yandex.webmaster.common.host.dao.TblHostsMainDao;
import ru.yandex.wmconsole.data.info.AddHostInfo;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.wrappers.AddHostInfoWrapper;
import ru.yandex.wmconsole.service.AddHostService;
import ru.yandex.wmconsole.util.HostElementWrapper;
import ru.yandex.wmtools.common.SupportedProtocols;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;

import java.net.URL;

public class AddSiteServantlet extends AuthenticationServantlet {
    private static final Logger log = LoggerFactory.getLogger(AddSiteServantlet.class);

    private static final String PARAM_HOST_NAME = "hostname";
    private static final String PARAM_YA_LANG = "_ya_lang";
    private static final String PARAM_REMOTE_IP = "_remote_ip";
    private static final String PARAM_YANDEX_UID = "_yandexuid";
    private static final String PARAM_FORCE_MIRRORS = "force-mirrors";

    private static final String PARAM_HOST_ID = "host_id";

    private AddHostService addHostService;
    private TblHostsMainDao tblHostsMainDao;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId)
            throws UserException, InternalException {

        String hostname = getStringParam(req, PARAM_HOST_NAME);
        if (hostname == null) {
            Long hostId = getLongParam(req, PARAM_HOST_ID);
            if (hostId == null) {
                final String message = "Required parameter missed: " + PARAM_HOST_NAME;
                throw new UserException(UserProblem.REQUIRED_PARAM_MISSED, message, PARAM_HOST_NAME);
            }
            BriefHostInfo hostInfo = tblHostsMainDao.getBriefHostInfoByHostId(hostId);
            if (hostInfo == null) {
                final String message = "host " + hostId + " not found in database";
                throw new UserException(UserProblem.HOST_NOT_FOUND_IN_DATABASE, message);
            }
            hostname = hostInfo.getName();
        } else {
            hostname = hostname.toLowerCase();
        }

        URL url = prepareHostname(hostname, true);
        boolean forceMirrors = getBooleanParam(req, PARAM_FORCE_MIRRORS, false);

        log.debug("Adding host " + url);
        String userIp = getStringParam(req, PARAM_REMOTE_IP);
        String yandexUid = getStringParam(req, PARAM_YANDEX_UID);
        AddHostInfo info = addHostService.addHostAllowMirrors(userId, req.getUserId(), url, userIp, req.getRemoteIp(), yandexUid,
                true, getYaDomainParam(req), getStringParam(req, PARAM_YA_LANG), forceMirrors, true);
        res.addData(new HostElementWrapper(
                new AddHostInfoWrapper(info),
                new BriefHostInfo(info.getHostId(), SupportedProtocols.getCanonicalHostname(url), info.getMainMirrorId())));
    }

    @Required
    public void setAddHostService(AddHostService addHostService) {
        this.addHostService = addHostService;
    }

    @Required
    public void setTblHostsMainDao(TblHostsMainDao tblHostsMainDao) {
        this.tblHostsMainDao = tblHostsMainDao;
    }
}
