package ru.yandex.wmconsole.servantlet.hostlist;

import java.util.Collection;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.framework.pager.Pager;
import ru.yandex.wmconsole.data.info.FastHostInfo;
import ru.yandex.wmconsole.data.wrappers.FastHostInfoWrapper;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.FastHostListService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

public class FastHostListServantlet extends WMCAuthenticationServantlet {
    private FastHostListService fastHostListService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws InternalException, UserException {
        Pager pager = createOutputStrategy(req).createPager();

        Collection<FastHostInfo> hostInfos = fastHostListService.getFastHostList(pager, userId, true, true);

        res.addData(XmlConvertableCollectionWrapper.wrap(hostInfos, FastHostInfoWrapper.class, "hostlist"));
        res.addData(pager);
    }

    @Required
    public void setFastHostListService(FastHostListService fastHostListService) {
        this.fastHostListService = fastHostListService;
    }
}
