package ru.yandex.wmconsole.servantlet.internal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.SeverityEnum;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.ErrorUrlInfo;
import ru.yandex.wmconsole.data.info.HostInfo;
import ru.yandex.wmconsole.data.wrappers.BarExportHostInfoWrapper;
import ru.yandex.wmconsole.data.wrappers.ErrorUrlInfoWrapper;
import ru.yandex.wmconsole.servantlet.WMCAuthorizedHostOperationServantlet;
import ru.yandex.wmconsole.service.ErrorInfoService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

public class BarExportHostInfoServantlet extends WMCAuthorizedHostOperationServantlet {
    private static final Logger log = LoggerFactory.getLogger(BarExportHostInfoServantlet.class);

    private static final String PARAM_VERSION = "version";

    private ErrorInfoService errorInfoService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws InternalException, UserException {

        Integer version = getIntParam(req, PARAM_VERSION);
        if (version == null) {
            version = 1;
        }
        log.debug("BarExportHostInfo requested, vesion = " + version);

        BriefHostInfo briefHostInfo = getHostInfoAndCheckHostAdded(req, userId);
        HostInfo hostInfo = getHostInfoService().getHostInfo(userId, briefHostInfo);

        res.addData(new BarExportHostInfoWrapper(hostInfo, false));

        ErrorUrlInfo errorUrlInfo = errorInfoService.getIndexPageError(userId, briefHostInfo);
        if (errorUrlInfo != null && SeverityEnum.ERROR.equals(errorUrlInfo.getSeverity())) {
            res.addData(new ErrorUrlInfoWrapper(errorUrlInfo));
        }
    }

    @Required
    public void setErrorInfoService(ErrorInfoService errorInfoService) {
        this.errorInfoService = errorInfoService;
    }
}
