package ru.yandex.wmconsole.servantlet.internal;

import java.util.Collection;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.FastHostInfo;
import ru.yandex.wmconsole.data.wrappers.FastHostInfoWrapper;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.FastHostListService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

public class BarExportHostListServantlet extends WMCAuthenticationServantlet {
    private static final Logger log = LoggerFactory.getLogger(BarExportHostListServantlet.class);

    private static final String PARAM_VERSION = "version";

    private FastHostListService fastHostListService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {

        Integer version = getIntParam(req, PARAM_VERSION);
        if (version == null) {
            version = 1;
        }
        log.debug("BarExportHostList requested, vesion = " + version);

        Collection<FastHostInfo> hostInfos;
        if (version >= 2) {
            hostInfos = fastHostListService.getFastHostList(null, userId, false, false);
        } else {
            hostInfos = fastHostListService.getFastHostList(null, userId, true, true);
        }
        res.addData(XmlConvertableCollectionWrapper.wrap(hostInfos, FastHostInfoWrapper.class, "hostlist"));
    }

    @Required
    public void setFastHostListService(FastHostListService fastHostListService) {
        this.fastHostListService = fastHostListService;
    }
}
