package ru.yandex.wmconsole.servantlet.internal;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.wrappers.StringWrapper;
import ru.yandex.wmconsole.service.DispatcherHttpService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AbstractServantlet;

/**
 * @author ailyin
 */
public class MainMirrorServantlet extends AbstractServantlet {
    private static final String PARAM_HOSTNAME = "hostname";

    private DispatcherHttpService dispatcherHttpService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res) throws InternalException, UserException {
        String hostname = getRequiredStringParam(req, PARAM_HOSTNAME);
        // Используем версию без кэша, так как только один вызов
        String mainMirror = dispatcherHttpService.getMainMirror(hostname);

        res.addData(new StringWrapper(mainMirror, "main-mirror"));
    }

    @Required
    public void setDispatcherHttpService(DispatcherHttpService dispatcherHttpService) {
        this.dispatcherHttpService = dispatcherHttpService;
    }
}
