package ru.yandex.wmconsole.servantlet.internal;

import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.wrappers.ListWrapper;
import ru.yandex.wmconsole.service.VerifyViewerService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AbstractServantlet;

/**
 * @author ailyin
 */
public class UserListServantlet extends AbstractServantlet {
    private static final String PARAM_HOSTNAME = "hostname";

    private VerifyViewerService verifyService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res) throws InternalException, UserException {
        String hostname = getRequiredStringParam(req, PARAM_HOSTNAME);
        List<Long> uids = verifyService.getUserIdsByHostname(hostname);

        res.addData(new ListWrapper<Long>(uids, "uids", "uid"));
    }

    @Required
    public void setVerifyService(VerifyViewerService verifyService) {
        this.verifyService = verifyService;
    }
}
