package ru.yandex.wmconsole.servantlet.mainmirror;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.servantlet.WMCAuthenticationServantlet;
import ru.yandex.wmconsole.service.MirrorGroupsChangeService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * User: azakharov
 * Date: 28.04.14
 * Time: 12:58
 */
public class MainMirrorSetNotifiedServantlet extends WMCAuthenticationServantlet {

    private MirrorGroupsChangeService mirrorGroupsChangeService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        BriefHostInfo briefHostInfo = getHostInfoAndVerify(req, userId);
        mirrorGroupsChangeService.markNotified(briefHostInfo);
    }

    @Required
    public void setMirrorGroupsChangeService(MirrorGroupsChangeService mirrorGroupsChangeService) {
        this.mirrorGroupsChangeService = mirrorGroupsChangeService;
    }
}
