package ru.yandex.wmconsole.servantlet.messages;

import java.util.Arrays;
import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.service.MessageService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;

public class MessageChangeServantlet extends AuthenticationServantlet {
    private static final String PARAM_READALL = "readall";
    private static final String PARAM_HIDEALL = "removeall";
    private static final String PARAM_MESSAGE = "message";
    private static final String PARAM_ACTION = "action";
    private static final String ACTION_UNREAD = "unread";
    private static final String ACTION_READ = "read";
    private static final String ACTION_HIDE = "remove";

    protected MessageService messageService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        checkService(messageService, MessageService.class);

        if (req.getParam(PARAM_READALL, true) != null) {
            messageService.markAllRead(userId);
            return;
        }
        if (req.getParam(PARAM_HIDEALL, true) != null) {
            messageService.markAllHidden(userId);
            return;
        }

        String action = getRequiredStringParam(req, PARAM_ACTION);
        List<Long> messages = Arrays.asList(getMultiParamLong(req, PARAM_MESSAGE));

        if (messages.isEmpty()) {
            return;
        }
        messageService.checkUserOwnMessages(messages, userId);

        if (ACTION_HIDE.equals(action)) {
            messageService.markHidden(messages, userId);
        }

        if (ACTION_READ.equals(action)) {
            messageService.markRead(messages, userId);
        }

        if (ACTION_UNREAD.equals(action)) {
            messageService.markUnread(messages, userId);
        }
    }

    @Required
    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }
}
