package ru.yandex.wmconsole.servantlet.messages;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.NotificationTypeEnum;
import ru.yandex.wmconsole.data.info.NotificationTypeInfo;
import ru.yandex.wmconsole.data.wrappers.NotificationTypeInfoWrapper;
import ru.yandex.wmconsole.service.MessageService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

/**
 * @author avhaliullin
 */
public class MessageGroupsServantlet extends AuthenticationServantlet {
    private static final String TAG_TYPES = "types";
    private static final String TAG_TYPE = "notification-type";

    private MessageService messageService;

    private NotificationTypeEnum getType(NotificationTypeInfo info) {
        NotificationTypeEnum res = NotificationTypeEnum.R.fromValueOrNull(info.getType());
        return res == null ? NotificationTypeEnum.SERVICE_MESSAGE : res;
    }

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        List<NotificationTypeInfo> types = messageService.getMessageTypesForUser(userId);
        Collections.sort(types, new Comparator<NotificationTypeInfo>() {
            @Override
            public int compare(NotificationTypeInfo o1, NotificationTypeInfo o2) {
                int p1 = getType(o1).getPriority();
                int p2 = getType(o2).getPriority();
                if (p1 == p2) {
                    return o1.getType() - o2.getType();
                }
                return p1 - p2;
            }
        });
        res.addData(XmlConvertableCollectionWrapper.wrap(types, NotificationTypeInfoWrapper.class, TAG_TYPES));
    }

    @Required
    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }
}
