package ru.yandex.wmconsole.servantlet.messages;

import java.util.Arrays;
import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.common.framework.pager.Pager;
import ru.yandex.wmconsole.data.info.NotificationMessageInfo;
import ru.yandex.wmconsole.data.wrappers.NotificationMessageWrapper;
import ru.yandex.wmconsole.service.MessageService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

/**
 * Servantlet for viewing the list of user's internal notification messages
 *
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class MessageListServantlet extends AuthenticationServantlet {
    private static final String TAG_NOTIFICATIONS_LIST = "notifications-list";
    private static final String PARAM_MESSAGE_TYPE = "type";

    protected MessageService messageService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId)
            throws InternalException {
        checkService(messageService, MessageService.class);

        Integer[] types = getMultiParamInt(req, PARAM_MESSAGE_TYPE);

        Pager pager = getOutputStrategy().createPager();
        List<NotificationMessageInfo> messages = messageService.getUserMessages(pager, userId, Arrays.asList(types));
        XmlConvertableCollectionWrapper wrapper = XmlConvertableCollectionWrapper.wrap(
                messages,
                NotificationMessageWrapper.class,
                TAG_NOTIFICATIONS_LIST
        );

        res.addData(wrapper);
        res.addData(pager);
    }

    @Required
    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }
}
