package ru.yandex.wmconsole.servantlet.messages;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.NotificationMessageInfo;
import ru.yandex.wmconsole.data.wrappers.NotificationMessageWrapper;
import ru.yandex.wmconsole.data.wrappers.StringWrapper;
import ru.yandex.wmconsole.service.MessageService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;

/**
 * Servantlet for viewing single internal notification message
 *
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class MessageServantlet extends AuthenticationServantlet {
    private static final Logger log = LoggerFactory.getLogger(MessageServantlet.class);

    private static final String PARAM_MESSAGE_ID = "id";

    protected MessageService messageService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId)
            throws UserException, InternalException {
        checkService(messageService, MessageService.class);
        Long messageId = getRequiredLongParam(req, PARAM_MESSAGE_ID);
        messageService.checkUserOwnsMessage(messageId, userId);
        NotificationMessageInfo message = messageService.getUserMessage(messageId, userId);
        Long prevId = messageService.getPrevNeighbourId(message);
        Long nextId = messageService.getNextNeighbourId(message);
        res.addData(new NotificationMessageWrapper(message));
        if (prevId != null) {
            res.addData(new StringWrapper(prevId.toString(), "prev"));
        }

        if (nextId != null) {
            res.addData(new StringWrapper(nextId.toString(), "next"));
        }

        try {
            messageService.markOneRead(messageId, userId);
        } catch (InternalException e) {
            log.error("Database error (possibly unable to write)", e);
        }
    }

    @Required
    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }
}
