package ru.yandex.wmconsole.servantlet.messages.options;

import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.LanguageEnum;
import ru.yandex.wmconsole.data.info.UserOptionsInfo;
import ru.yandex.wmconsole.data.wrappers.StringWrapper;
import ru.yandex.wmconsole.service.UserOptionsService;
import ru.yandex.wmtools.common.data.info.EmailInfo;
import ru.yandex.wmtools.common.data.wrappers.ValidatorWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.servantlet.AuthenticationServantlet;
import ru.yandex.wmtools.common.service.ValidatorService;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class ChannelOptionsInfoServantlet extends AuthenticationServantlet {
    private static final String EMPTY = "";
    private static final String TAG_EMAIL = "email";
    private static final String TAG_PHONE = "phone";
    private static final String TAG_EMAIL_LANG = "email-lang";

    private UserOptionsService userOptionsService;
    private ValidatorService validatorService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws InternalException {
        checkService(userOptionsService, UserOptionsService.class);

        UserOptionsInfo userOptions = userOptionsService.getUserOptions(userId);
        String email = userOptions.getEmail();
        LanguageEnum emailLanguage = userOptions.getEmailLanguage();
        Long phone = userOptions.getPhone();

        if (email != null) {
            res.addData(new StringWrapper(email, TAG_EMAIL));
        }

        if (emailLanguage != null) {
            res.addData(new StringWrapper(emailLanguage.getName(), TAG_EMAIL_LANG));
        } else {
            res.addData(new StringWrapper(LanguageEnum.DEFAULT_EMAIL_LANGUAGE.getName(), TAG_EMAIL_LANG));
        }

        if (phone != null) {
            if (phone != 0) {
                res.addData(new StringWrapper(phone.toString(), TAG_PHONE));
            } else {
                res.addData(new StringWrapper(EMPTY, TAG_PHONE));
            }
        }

        List<EmailInfo> emails = validatorService.getEmails(userId);
        res.addData(XmlConvertableCollectionWrapper.wrap(emails, ValidatorWrapper.class, "emails"));
    }

    @Required
    public void setUserOptionsService(UserOptionsService userOptionsService) {
        this.userOptionsService = userOptionsService;
    }

    @Required
    public void setValidatorService(ValidatorService validatorService) {
        this.validatorService = validatorService;
    }
}
