package ru.yandex.wmconsole.servantlet.metrika;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.webmaster.common.metrika.MetrikaProblemInfo;
import ru.yandex.webmaster.common.metrika.dao.TblMetrikaProblemsDao;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.servantlet.WMCAuthorizedHostOperationServantlet;
import ru.yandex.wmconsole.servantlet.metrika.data.MetrikaProblemWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * @author avhaliullin
 */
public class MetrikaCounterProblemServantlet extends WMCAuthorizedHostOperationServantlet {
    private TblMetrikaProblemsDao tblMetrikaProblemsDao;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        BriefHostInfo hostInfo = getHostInfoAndVerify(req, userId);
        MetrikaProblemInfo metrikaProblemInfo= tblMetrikaProblemsDao.getInfoForHost(hostInfo);
        if (metrikaProblemInfo != null){
            res.addData(new MetrikaProblemWrapper(metrikaProblemInfo));
        }
    }

    @Required
    public void setTblMetrikaProblemsDao(TblMetrikaProblemsDao tblMetrikaProblemsDao) {
        this.tblMetrikaProblemsDao = tblMetrikaProblemsDao;
    }
}
