package ru.yandex.wmconsole.servantlet.metrika.data;

import ru.yandex.webmaster.common.metrika.MetrikaProblemInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author avhaliullin
 */
public class MetrikaProblemWrapper extends XmlDataWrapper<MetrikaProblemInfo> {
    private static final String TAG_COUNTER_ID = "counter-id";
    private static final String TAG_RECHECK_REQUESTED = "recheck-requested";

    public MetrikaProblemWrapper(MetrikaProblemInfo data) {
        super(data, "metrika-problem");
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putLongTag(result, TAG_COUNTER_ID, data.getCounter());
        boolean recheckRequested = data.getRecheckRequested() != null && data.getRecheckRequested().isAfter(data.getLastChecked());
        putBooleanTag(result, TAG_RECHECK_REQUESTED, recheckRequested);
    }
}
