package ru.yandex.wmconsole.servantlet.offline;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.servantlet.WMCAuthorizedHostOperationServantlet;
import ru.yandex.wmconsole.service.OfflineLinksService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

public class SetOfflineLinksOptionServantlet extends WMCAuthorizedHostOperationServantlet {
    private static final String PARAM_OFFLINE_LINKS_ENABLED = "offline-links-enabled";
    private static final String PARAM_HOST = "host";

    private OfflineLinksService offlineLinksService;

    @Override
    public void doProcess(ServRequest req, ServResponse res, long userId) throws InternalException, UserException {
        Long host = getLongParam(req, PARAM_HOST);
        Boolean offlineLinksEnabledParam = getBooleanParam(req, PARAM_OFFLINE_LINKS_ENABLED);
        boolean offlineLinksEnabled = (offlineLinksEnabledParam != null) && offlineLinksEnabledParam;
        if (host != null) {
            BriefHostInfo hostInfo = getHostInfoAndVerify(req, userId);
            offlineLinksService.updateOfflineLinksOption(userId, hostInfo.getId(), offlineLinksEnabled);
        } else {
            getUserInfoService().updateOfflineLinksOption(userId, offlineLinksEnabled);
        }
    }

    @Required
    public void setOfflineLinksService(OfflineLinksService offlineLinksService) {
        this.offlineLinksService = offlineLinksService;
    }
}
