package ru.yandex.wmconsole.servantlet.regions;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.servantlet.WMCAuthorizedHostOperationServantlet;
import ru.yandex.wmconsole.service.HostDbHostInfoService;
import ru.yandex.wmconsole.service.HostRegionService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * Date: May 13, 2009
 *
 * @author baton
 */
public class HostRegionRefuseConfirmServantlet extends WMCAuthorizedHostOperationServantlet {
    private HostDbHostInfoService hostDbHostInfoService;
    private HostRegionService hostRegionService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId)
            throws InternalException, UserException {

        BriefHostInfo hostInfo = getHostInfoAndVerify(req, userId);
        HostDbHostInfo hostDbHostInfo = hostDbHostInfoService.getHostDbHostInfo(hostInfo.getName());

        hostRegionService.confirmUserHostRegionRefuse(userId, hostDbHostInfo);
    }

    @Required
    public void setHostDbHostInfoService(HostDbHostInfoService hostDbHostInfoService) {
        this.hostDbHostInfoService = hostDbHostInfoService;
    }

    @Required
    public void setHostRegionService(HostRegionService hostRegionService) {
        this.hostRegionService = hostRegionService;
    }
}
