package ru.yandex.wmconsole.servantlet.regions;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.webmaster.viewer.service.NewWebmasterProxyService;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.data.info.TcyInfo;
import ru.yandex.wmconsole.data.info.UserHostRegionInfo;
import ru.yandex.wmconsole.data.wrappers.TcyInfoWrapper;
import ru.yandex.wmconsole.data.wrappers.UserHostRegionInfoWrapper;
import ru.yandex.wmconsole.servantlet.WMCAuthorizedHostOperationServantlet;
import ru.yandex.wmconsole.service.HostDbHostInfoService;
import ru.yandex.wmconsole.service.HostRegionService;
import ru.yandex.wmconsole.service.LinksCacheService;
import ru.yandex.wmconsole.util.HostElementWrapper;
import ru.yandex.wmtools.common.SupportedProtocols;
import ru.yandex.wmtools.common.data.RegionTypeEnum;
import ru.yandex.wmtools.common.data.info.HostRegionInfo;
import ru.yandex.wmtools.common.data.info.HostRegionsInfo;
import ru.yandex.wmtools.common.data.info.RegionInfo;
import ru.yandex.wmtools.common.data.wrappers.HostRegionsInfoWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * @author baton
 */
public class HostRegionsInfoServantlet extends WMCAuthorizedHostOperationServantlet {
    public static final int TCY_LIMIT = 0;

    private HostDbHostInfoService hostDbHostInfoService;
    private HostRegionService hostRegionService;
    private LinksCacheService linksCacheService;
    private NewWebmasterProxyService newWebmasterProxyService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId)
            throws InternalException, UserException {

        BriefHostInfo hostInfo = getHostInfoAndVerify(req, userId);
        if (hostInfo == null) {
            return;
        }
        checkIndexed(hostInfo);
        URL hostname;
        try {
            hostname = SupportedProtocols.getURL(hostInfo.getName());
        } catch (MalformedURLException e) {
            throw new AssertionError("invalid hostname in a database!");
        } catch (URISyntaxException e) {
            throw new AssertionError("invalid hostname in a database!");
        } catch (SupportedProtocols.UnsupportedProtocolException e) {
            throw new AssertionError("there is a host in a database with unsupported protocol!");
        }

        Integer tcyValue = linksCacheService.checkCacheAndGetTcy(hostname);
        final int tcy = (tcyValue == null) ? 0 : tcyValue;
        if (tcy < TCY_LIMIT) {
            res.addData(new TcyInfoWrapper(new TcyInfo(TCY_LIMIT, tcy)));
        }

        HostDbHostInfo hostDbHostInfo = hostDbHostInfoService.getHostDbHostInfo(hostInfo.getName());
        HostRegionsInfo hostRegionsInfo = hostRegionService.getVisibleRegionsForHost(hostDbHostInfo);
        boolean hasCatalogRegions = false;
        for (HostRegionInfo region : hostRegionsInfo.getRegions()) {
            if (region.getRegionType() == RegionTypeEnum.CATALOG) {
                hasCatalogRegions = true;
            }
        }
        UserHostRegionInfo userHostRegionInfo = null;

        NewWebmasterProxyService.RegionInfoResponse newWMResponse = hasCatalogRegions ? null : newWebmasterProxyService.getHostRegionInfo(hostInfo);
        if (newWMResponse != null) {
            userHostRegionInfo = newWMResponse.userHostRegionInfo;
            if (newWMResponse.pendingRegion != null && newWMResponse.webmasterRegion != null &&
                    newWMResponse.pendingRegion.getRegionInfo().getId() == newWMResponse.webmasterRegion.getRegionInfo().getId()) {
                List<HostRegionInfo> newRegionInfos = new ArrayList<>();
                for (HostRegionInfo regionInfo : hostRegionsInfo.getRegions()) {
                    if (regionInfo.getRegionType() == RegionTypeEnum.CATALOG) {
                        newRegionInfos.add(regionInfo);
                    }
                }
                newRegionInfos.add(newWMResponse.webmasterRegion);
                hostRegionsInfo = new HostRegionsInfo(newRegionInfos);
                if (userHostRegionInfo != null &&
                        userHostRegionInfo.getUserClassificationInfo() != null &&
                        userHostRegionInfo.getUserClassificationInfo().getRegionInfo() != null &&
                        userHostRegionInfo.getUserClassificationInfo().getRegionInfo().getId() == newWMResponse.webmasterRegion.getRegionInfo().getId()) {
                    userHostRegionInfo = null;
                }
            }
        }

        final UserHostRegionInfo userHostRegionInfo2 = userHostRegionInfo;
        res.addData(new HostElementWrapper(new HostRegionsInfoWrapper(hostRegionsInfo), hostInfo) {
            @Override
            protected void doToXml(StringBuilder result) {
                super.doToXml(result);
                if (userHostRegionInfo2 != null) {
                    new UserHostRegionInfoWrapper(userHostRegionInfo2).toXml(result);
                }
            }
        });
    }

    @Required
    public void setHostRegionService(HostRegionService hostRegionService) {
        this.hostRegionService = hostRegionService;
    }

    @Required
    public void setHostDbHostInfoService(HostDbHostInfoService hostDbHostInfoService) {
        this.hostDbHostInfoService = hostDbHostInfoService;
    }

    @Required
    public void setLinksCacheService(LinksCacheService linksCacheService) {
        this.linksCacheService = linksCacheService;
    }

    @Required
    public void setNewWebmasterProxyService(NewWebmasterProxyService newWebmasterProxyService) {
        this.newWebmasterProxyService = newWebmasterProxyService;
    }
}
