package ru.yandex.wmconsole.servantlet.seolinks;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.webmaster.common.seolinks.SeoLinksSettingsService;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.servantlet.WMCAuthorizedHostOperationServantlet;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * User: azakharov
 * Date: 05.06.14
 * Time: 15:40
 */
public class SeoLinksChangeServantlet extends WMCAuthorizedHostOperationServantlet {

    private static final String PARAM_IGNORE_SEO_LINKS = "ignore-seo-links";

    private SeoLinksSettingsService seoLinksSettingsService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        BriefHostInfo hostInfo = getHostInfoAndVerify(req, userId);
        Boolean ignoreSeoLinks = getRequiredCheckboxBooleanParam(req, PARAM_IGNORE_SEO_LINKS);
        seoLinksSettingsService.saveSeoLinksOptions(hostInfo.getName().toLowerCase(), !ignoreSeoLinks, userId);
    }

    @Required
    public void setSeoLinksSettingsService(SeoLinksSettingsService seoLinksSettingsService) {
        this.seoLinksSettingsService = seoLinksSettingsService;
    }
}
