package ru.yandex.wmconsole.servantlet.seolinks;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.webmaster.common.seolinks.SeoLinksSettingsService;
import ru.yandex.webmaster.common.seolinks.info.SeoLinksInfo;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.servantlet.WMCAuthorizedHostOperationServantlet;
import ru.yandex.wmconsole.servantlet.seolinks.wrapper.SeoLinksInfoWrapper;
import ru.yandex.wmconsole.util.HostElementWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * User: azakharov
 * Date: 05.06.14
 * Time: 14:29
 */
public class SeoLinksInfoServantlet extends WMCAuthorizedHostOperationServantlet {

    private SeoLinksSettingsService seoLinksSettingsService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {
        BriefHostInfo hostInfo = getHostInfoAndVerify(req, userId);

        // get seo links info
        SeoLinksInfo info = seoLinksSettingsService.getSeoLinksInfo(hostInfo.getName().toLowerCase());

        res.addData(new HostElementWrapper(new SeoLinksInfoWrapper(info, false), hostInfo));
    }

    @Required
    public void setSeoLinksSettingsService(SeoLinksSettingsService seoLinksSettingsService) {
        this.seoLinksSettingsService = seoLinksSettingsService;
    }
}
