package ru.yandex.wmconsole.servantlet.seolinks.wrapper;

import ru.yandex.webmaster.common.seolinks.info.SeoLinksInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * User: azakharov
 * Date: 05.06.14
 * Time: 14:33
 */
public class SeoLinksInfoWrapper extends XmlDataWrapper<SeoLinksInfo> {

    private final boolean hasSanctions;

    public SeoLinksInfoWrapper(SeoLinksInfo data, boolean hasSanctions) {
        super(data, "seo-links");
        this.hasSanctions = hasSanctions;
    }

    @Override
    protected void doToXml(StringBuilder result) {
        // seo-links-settings
        putBooleanTag(result, "ignore-seo-links", !data.isUseSeoLinks());
        putDateTag(result, "modified-on", data.getModifiedOn());
        putDateTag(result, "modification-disallowed-until", data.getModificationDisallowedUntil());
        putBooleanTag(result, "allow-modification", data.isModificationAllowed());

        // antispam sanctions
        putBooleanTag(result, "has-sanctions", hasSanctions);
    }
}
