package ru.yandex.wmconsole.servantlet.serplinks;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.webmaster.common.urltree.YandexSearchShard;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.data.info.SerpLinkInfo;
import ru.yandex.wmconsole.data.info.XMLSerpLinkInfo;
import ru.yandex.wmconsole.data.wrappers.SerpLinkInfoWrapper;
import ru.yandex.wmconsole.data.wrappers.XMLSerpLinkWrapper;
import ru.yandex.wmconsole.servantlet.WMCAuthorizedHostOperationServantlet;
import ru.yandex.wmconsole.service.HostDbHostInfoService;
import ru.yandex.wmconsole.service.SerpLinksService;
import ru.yandex.wmconsole.service.dao.TblUrlTreesDao;
import ru.yandex.wmconsole.service.error.WMCUserProblem;
import ru.yandex.wmconsole.util.HostElementWrapper;
import ru.yandex.wmtools.common.data.wrappers.SimpleWrapper;
import ru.yandex.wmtools.common.data.wrappers.StringWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

/**
 * WIKI: http://wiki.yandex-team.ru/JandeksPoisk/Interfejjsy/PrincipySerpa/SiteLinks/viewer
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class SerpLinksInfoServantlet extends WMCAuthorizedHostOperationServantlet {
    private static final String ALPHA_SORT_TAG = "alphasort";
    private static final String PARAM_SECTION = "section";

    private static final Logger log = LoggerFactory.getLogger(SerpLinksInfoServantlet.class);

    private SerpLinksService serpLinksService;
    private TblUrlTreesDao tblUrlTreesDao;
    private HostDbHostInfoService hostDbHostInfoService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws InternalException, UserException {

        BriefHostInfo briefHostInfo = getHostInfo(req, false, userId, true, true, res, true, true);
        if (briefHostInfo == null) {
            return;
        }

        if (getUsersHostsService().getHostVerifiedUserIds(briefHostInfo.getId()).contains(userId)) {
            String path = getStringParam(req, PARAM_SECTION);
            String sectionUrl = XMLSerpLinkInfo.getSectionName(briefHostInfo.getName(), path);

            YandexSearchShard searchShard = YandexSearchShard.RU;
            try {
                HostDbHostInfo hostDbHostInfo = hostDbHostInfoService.getHostDbHostInfo(briefHostInfo.getName());
                searchShard = tblUrlTreesDao.getOptimumShardId(hostDbHostInfo);
            } catch (InternalException e) {
                log.error("InternalException while getting yandex search shard", e);
            }
            // Быстрые ссылки, которые сейчас есть в поиске
            List<XMLSerpLinkInfo> xmlSerpLinks = serpLinksService.getXMLSearchSerpLinkInfo(
                    sectionUrl, searchShard);

            // Быстрые ссылки, которые будут после обновления
            SerpLinkInfo serpLinkInfo = serpLinksService.getSerpLinkInfo(sectionUrl);
            List<SerpLinkInfo.SerpLinksPage> pages = serpLinkInfo.getPages();

            XmlConvertableCollectionWrapper wrappedSerpLinkInfos = XmlConvertableCollectionWrapper.wrap(pages, SerpLinkInfoWrapper.class, "serplinks");
            XmlConvertableCollectionWrapper wrappedXMLSerpLinkInfos = XmlConvertableCollectionWrapper.wrap(xmlSerpLinks, XMLSerpLinkWrapper.class, "xmlserplinks");
            res.addData(new HostElementWrapper(wrappedSerpLinkInfos, briefHostInfo));
            res.addData(new SimpleWrapper<String>(Boolean.toString(serpLinkInfo.isAlphaSort()), ALPHA_SORT_TAG));
            res.addData(wrappedXMLSerpLinkInfos);
            res.addData(new StringWrapper("section", sectionUrl));
        } else {
            throw new UserException(WMCUserProblem.HOST_NOT_OWNED_BY_USER, "Host not owned by user");
        }
    }

    @Required
    public void setSerpLinksService(SerpLinksService serpLinksService) {
        this.serpLinksService = serpLinksService;
    }

    @Required
    public void setTblUrlTreesDao(TblUrlTreesDao tblUrlTreesDao) {
        this.tblUrlTreesDao = tblUrlTreesDao;
    }

    @Required
    public void setHostDbHostInfoService(HostDbHostInfoService hostDbHostInfoService) {
        this.hostDbHostInfoService = hostDbHostInfoService;
    }
}
