package ru.yandex.wmconsole.servantlet.serplinks;

import java.net.URL;
import java.util.LinkedList;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.servantlet.WMCAuthorizedHostOperationServantlet;
import ru.yandex.wmconsole.service.SerpLinksService;
import ru.yandex.wmconsole.service.error.WMCUserProblem;
import ru.yandex.wmconsole.util.WwwUtil;
import ru.yandex.wmtools.common.data.wrappers.StringWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AbstractServantlet;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

/**
 * User: azakharov
 * Date: 20.06.12
 * Time: 13:07
 */
public class SerpLinksSectionsServantlet extends WMCAuthorizedHostOperationServantlet {
    private static final String TAG_SECTIONS = "sections";
    private static final String TAG_SECTION = "section";

    private SerpLinksService serpLinksService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws InternalException, UserException {

        BriefHostInfo briefHostInfo = getHostInfo(req, false, userId, true, true, res, true, true);
        if (briefHostInfo == null) {
            return;
        }

        if (getUsersHostsService().getHostVerifiedUserIds(briefHostInfo.getId()).contains(userId)) {
            LinkedList<StringWrapper> sections = new LinkedList<StringWrapper>();
            for (String s : serpLinksService.getSections(briefHostInfo.getName())) {
                URL url = AbstractServantlet.prepareUrl(s, true);
                if (WwwUtil.equalsIgnoreWww(briefHostInfo.getName(), getHostName(url))) {
                    sections.add(new StringWrapper(TAG_SECTION, getPath(url)));
                }
            }
            res.addData(new XmlConvertableCollectionWrapper(sections, TAG_SECTIONS));
        } else {
            throw new UserException(WMCUserProblem.HOST_NOT_OWNED_BY_USER, "Host not owned by user");
        }
    }

    private String getPath(URL url) {
        return StringUtils.isEmpty(url.getPath()) ? "/" : url.getPath();
    }

    @Required
    public void setSerpLinksService(SerpLinksService serpLinksService) {
        this.serpLinksService = serpLinksService;
    }
}
