package ru.yandex.wmconsole.servantlet.services;

import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.ServiceOptionsInfo;
import ru.yandex.wmconsole.data.wrappers.ServiceOptionsInfoWrapper;
import ru.yandex.wmconsole.service.ServiceOptionsService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AbstractServantlet;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

/**
 * Выводит список сервисов с их настройками. В отличие от ServicesOptionsInfoServantlet не требует авторизации
 *
 * @author azakharov
 */
public class PublicServicesOptionsServantlet extends AbstractServantlet {
    private ServiceOptionsService serviceOptionsService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res) throws UserException, InternalException {
        checkService(serviceOptionsService, ServiceOptionsService.class);
        List<ServiceOptionsInfo> options = serviceOptionsService.getAllServices();
        res.addData(XmlConvertableCollectionWrapper.wrap(options, ServiceOptionsInfoWrapper.class, "service-options"));
    }

    @Required
    public void setServiceOptionsService(ServiceOptionsService serviceOptionsService) {
        this.serviceOptionsService = serviceOptionsService;
    }
}
