package ru.yandex.wmconsole.servantlet.services;

import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.info.ServiceOptionsInfo;
import ru.yandex.wmconsole.data.wrappers.ServiceOptionsInfoWrapper;
import ru.yandex.wmconsole.servantlet.WMCAuthorizedHostOperationServantlet;
import ru.yandex.wmconsole.service.ServiceOptionsService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

/**
 * Outputs a list of all services with their options.
 *
 * @author ailyin
 */
public class ServicesOptionsInfoServantlet extends WMCAuthorizedHostOperationServantlet {
    private ServiceOptionsService serviceOptionsService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res, long userId) throws UserException, InternalException {

        BriefHostInfo hostInfo = getHostInfoAndVerify(req, userId);
        List<ServiceOptionsInfo> options = serviceOptionsService.getServicesOptions(hostInfo);

        res.addData(XmlConvertableCollectionWrapper.wrap(options, ServiceOptionsInfoWrapper.class, "service-options"));
    }

    @Required
    public void setServiceOptionsService(ServiceOptionsService serviceOptionsService) {
        this.serviceOptionsService = serviceOptionsService;
    }
}
